/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.epl.downloader;

import com.aptana.core.epl.CoreEPLPlugin;
import com.aptana.core.epl.downloader.ConnectionData;
import com.aptana.core.epl.downloader.FileInfo;
import com.aptana.core.epl.downloader.Messages;
import com.aptana.core.epl.downloader.ProgressStatistics;
import com.aptana.core.epl.downloader.RepositoryStatusHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferConnectStartEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceivePausedEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveResumedEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.osgi.util.NLS;

public class FileReader
extends FileTransferJob
implements IFileTransferListener {
    private static IFileReaderProbe testProbe;
    private boolean closeStreamWhenFinished = false;
    private Exception exception;
    private FileInfo fileInfo;
    private long lastProgressCount;
    private long lastStatsCount;
    protected IProgressMonitor theMonitor;
    private OutputStream theOutputStream;
    private ProgressStatistics statistics;
    private final int connectionRetryCount;
    private final long connectionRetryDelay;
    private final IConnectContext connectContext;
    private URI requestUri;
    protected IFileTransferConnectStartEvent connectEvent;
    private Job cancelJob;
    private boolean monitorStarted;
    private boolean isPause = false;
    private boolean hasPaused = false;
    private IFileTransferPausable pausable = null;

    public FileReader(ConnectionData connectionData, IConnectContext aConnectContext) {
        super(Messages.FileReader_fileTrasportReader);
        this.setSystem(true);
        this.setUser(false);
        if (connectionData == null) {
            this.connectionRetryCount = 1;
            this.connectionRetryDelay = 200L;
        } else {
            this.connectionRetryCount = connectionData.getRetryCount();
            this.connectionRetryDelay = connectionData.getRetryDelay();
        }
        this.connectContext = aConnectContext;
    }

    public FileInfo getLastFileInfo() {
        return this.fileInfo;
    }

    public synchronized void handleTransferEvent(IFileTransferEvent event) {
        if (event instanceof IFileTransferConnectStartEvent) {
            this.connectEvent = (IFileTransferConnectStartEvent)event;
            this.cancelJob = new CancelHandler();
            this.cancelJob.schedule(500L);
        } else if (event instanceof IIncomingFileTransferReceiveStartEvent) {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
            }
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            try {
                FileInfo fi = new FileInfo();
                Date lastModified = source.getRemoteLastModified();
                if (lastModified != null) {
                    fi.setLastModified(lastModified.getTime());
                }
                fi.setName(source.getRemoteFileName());
                fi.setSize(source.getFileLength());
                this.fileInfo = fi;
                ((IIncomingFileTransferReceiveStartEvent)event).receive(this.theOutputStream, (FileTransferJob)this);
            }
            catch (IOException e) {
                this.exception = e;
                return;
            }
            long fileLength = source.getFileLength();
            ProgressStatistics stats = new ProgressStatistics(this.requestUri, source.getRemoteFileName(), fileLength);
            this.setStatistics(stats);
            if (this.theMonitor != null) {
                this.theMonitor.beginTask(null, 1000);
                this.monitorStarted = true;
                this.theMonitor.subTask(stats.report());
                this.lastStatsCount = 0L;
                this.lastProgressCount = 0L;
            }
            this.onStart(source);
        } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            if (this.theMonitor != null) {
                if (this.theMonitor.isCanceled()) {
                    this.completeTransfer(event);
                    return;
                }
                long br = source.getBytesReceived();
                long count = br - this.lastStatsCount;
                this.lastStatsCount = br;
                ProgressStatistics stats = this.getStatistics();
                if (stats != null) {
                    stats.increase(count);
                    this.fileInfo.setAverageSpeed(stats.getAverageSpeed());
                    if (stats.shouldReport()) {
                        count = br - this.lastProgressCount;
                        this.lastProgressCount = br;
                        this.theMonitor.subTask(stats.report());
                        this.theMonitor.worked((int)(1000L * count / stats.getTotal()));
                    }
                }
            }
            this.pauseIfPossible(source);
            this.onData(source);
        } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
            this.completeTransfer(event);
        } else if (event instanceof IIncomingFileTransferReceivePausedEvent) {
            this.hasPaused = true;
        } else if (event instanceof IIncomingFileTransferReceiveResumedEvent) {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
            }
            try {
                try {
                    ((IIncomingFileTransferReceiveResumedEvent)event).receive(this.theOutputStream, (FileTransferJob)this);
                }
                catch (IOException e) {
                    this.exception = e;
                    this.hasPaused = false;
                }
            }
            finally {
                this.hasPaused = false;
            }
        }
    }

    private synchronized void pauseIfPossible(IIncomingFileTransfer source) {
        if (this.isSetToPause() && !this.hasPaused) {
            this.pausable = (IFileTransferPausable)source.getAdapter(IFileTransferPausable.class);
            if (this.pausable != null) {
                this.pausable.pause();
            }
        }
    }

    protected void completeTransfer(IFileTransferEvent event) {
        if (this.closeStreamWhenFinished) {
            FileReader.hardClose(this.theOutputStream);
        }
        if (this.exception == null && event instanceof IIncomingFileTransferReceiveDoneEvent) {
            this.exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
        }
        this.onDone(((IIncomingFileTransferEvent)event).getSource());
    }

    public InputStream read(URI url, IProgressMonitor monitor) throws CoreException, IOException {
        final PipedInputStream input = new PipedInputStream();
        PipedOutputStream output = new PipedOutputStream(input);
        this.sendRetrieveRequest(url, output, null, true, monitor);
        return new InputStream(){

            public int available() throws IOException {
                this.checkException();
                return input.available();
            }

            public void close() throws IOException {
                FileReader.hardClose(input);
                this.checkException();
            }

            public void mark(int readlimit) {
                input.mark(readlimit);
            }

            public boolean markSupported() {
                return input.markSupported();
            }

            public int read() throws IOException {
                this.checkException();
                return input.read();
            }

            public int read(byte[] b) throws IOException {
                this.checkException();
                return input.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.checkException();
                return input.read(b, off, len);
            }

            public void reset() throws IOException {
                this.checkException();
                input.reset();
            }

            public long skip(long n) throws IOException {
                this.checkException();
                return input.skip(n);
            }

            private void checkException() throws IOException {
                IOException e;
                if (FileReader.this.getException() == null) {
                    return;
                }
                Throwable t = this.unwind(FileReader.this.getException());
                if (t instanceof IOException) {
                    e = (IOException)t;
                } else {
                    e = new IOException(t.getMessage());
                    e.initCause(t);
                }
                throw e;
            }

            private Throwable unwind(Throwable t) {
                String msg;
                Throwable cause;
                Class<?> tc;
                while (!((tc = t.getClass()) != RuntimeException.class && tc != InvocationTargetException.class && tc != IOException.class || (cause = t.getCause()) == null || (msg = t.getMessage()) != null && !msg.equals(cause.toString()))) {
                    t = cause;
                }
                return t;
            }
        };
    }

    public void readInto(URI uri, OutputStream anOutputStream, IProgressMonitor monitor) throws CoreException, FileNotFoundException, ProtocolException {
        this.readInto(uri, anOutputStream, -1L, monitor);
    }

    public boolean belongsTo(Object family) {
        return family == this;
    }

    public void readInto(URI uri, OutputStream anOutputStream, long startPos, IProgressMonitor monitor) throws CoreException, FileNotFoundException, ProtocolException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                this.sendRetrieveRequest(uri, anOutputStream, startPos != -1L ? new DownloadRange(startPos) : null, true, monitor);
                this.getTheJobManager().join((Object)this, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                this.waitPaused(uri, anOutputStream, startPos, monitor);
                if (monitor.isCanceled() && this.connectEvent != null) {
                    this.connectEvent.cancel();
                }
                this.checkException(uri, this.connectionRetryCount);
            }
            catch (InterruptedException e) {
                monitor.setCanceled(true);
                throw new OperationCanceledException();
            }
        }
        finally {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
                this.cancelJob = null;
            }
            if (!this.monitorStarted) {
                monitor.beginTask(null, 1);
            }
            this.monitorStarted = false;
        }
    }

    protected void waitPaused(URI uri, OutputStream anOutputStream, long startPos, IProgressMonitor monitor) throws FileNotFoundException, CoreException, OperationCanceledException, InterruptedException {
        if (this.hasPaused) {
            while (this.hasPaused) {
                Thread.sleep(1000L);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            Job.getJobManager().join((Object)this, monitor);
            this.waitPaused(uri, anOutputStream, startPos, monitor);
        }
    }

    protected IJobManager getTheJobManager() {
        return FileReader.getJobManager();
    }

    protected synchronized void sendRetrieveRequest(URI uri, OutputStream outputStream, DownloadRange range, boolean closeStreamOnFinish, IProgressMonitor monitor) throws CoreException, FileNotFoundException, ProtocolException {
        IRetrieveFileTransferFactory factory = this.getRetrieveFileTransferFactory();
        if (factory == null) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core.epl", Messages.FileReader_initializationError));
        }
        IRetrieveFileTransfer adapter = factory.newInstance();
        adapter.setConnectContextForAuthentication(this.connectContext);
        Proxy proxy = this.getProxy(uri);
        adapter.setProxy(proxy);
        this.exception = null;
        this.closeStreamWhenFinished = closeStreamOnFinish;
        this.fileInfo = null;
        this.statistics = null;
        this.lastProgressCount = 0L;
        this.lastStatsCount = 0L;
        this.theMonitor = monitor;
        this.monitorStarted = false;
        this.theOutputStream = outputStream;
        this.requestUri = uri;
        int retryCount = 0;
        while (true) {
            block9: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IFileID fileID = this.getFileIDFactory().createFileID(adapter.getRetrieveNamespace(), uri.toString());
                    if (range != null) {
                        adapter.sendRetrieveRequest(fileID, (IFileRangeSpecification)range, (IFileTransferListener)this, null);
                    } else {
                        adapter.sendRetrieveRequest(fileID, (IFileTransferListener)this, null);
                    }
                }
                catch (IncomingFileTransferException e) {
                    this.exception = e;
                }
                catch (FileCreateException e) {
                    this.exception = e;
                }
                catch (Throwable t) {
                    if (this.exception == null) break block9;
                    this.exception.printStackTrace();
                }
            }
            if (this.checkException(uri, retryCount)) break;
            ++retryCount;
        }
    }

    protected Proxy getProxy(URI uri) {
        return ProxySetupHelper.getProxy((String)uri.toASCIIString());
    }

    protected FileIDFactory getFileIDFactory() {
        return FileIDFactory.getDefault();
    }

    protected IRetrieveFileTransferFactory getRetrieveFileTransferFactory() {
        return CoreEPLPlugin.getDefault().getRetrieveFileTransferFactory();
    }

    public synchronized boolean pause() {
        this.isPause = true;
        return true;
    }

    public boolean isSetToPause() {
        return this.isPause;
    }

    public synchronized boolean resume() {
        this.isPause = false;
        if (this.pausable != null) {
            return this.pausable.resume();
        }
        return false;
    }

    private boolean checkException(URI uri, int attemptCounter) throws CoreException, FileNotFoundException, ProtocolException {
        if (this.exception != null) {
            RepositoryStatusHelper.checkJREHttpClientRequired(this.exception);
            RepositoryStatusHelper.checkPermissionDenied(this.exception);
            RepositoryStatusHelper.checkFileNotFound(this.exception, uri);
            Throwable t = RepositoryStatusHelper.unwind(this.exception);
            if (t instanceof CoreException) {
                throw RepositoryStatusHelper.unwindCoreException((CoreException)t);
            }
            if (t instanceof SocketTimeoutException) {
                throw RepositoryStatusHelper.wrap(t);
            }
            if (t instanceof IOException && attemptCounter < this.connectionRetryCount) {
                this.exception = null;
                try {
                    CoreEPLPlugin.log((IStatus)new Status(2, "com.aptana.core.epl", NLS.bind((String)Messages.FileReader_connectionRetryMeggage, (Object[])new String[]{uri.toString(), t.getMessage(), String.valueOf(attemptCounter)}), t));
                    Thread.sleep(this.connectionRetryDelay);
                    return false;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            throw RepositoryStatusHelper.wrap(this.exception);
        }
        return true;
    }

    protected Exception getException() {
        return this.exception;
    }

    public static void hardClose(Object aStream) {
        if (aStream != null) {
            try {
                if (aStream instanceof OutputStream) {
                    OutputStream stream = (OutputStream)aStream;
                    stream.flush();
                    stream.close();
                } else if (aStream instanceof InputStream) {
                    ((InputStream)aStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void onDone(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onDone(this, source, this.theMonitor);
        }
    }

    private void onStart(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onStart(this, source, this.theMonitor);
        }
    }

    private void onData(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onData(this, source, this.theMonitor);
        }
    }

    public static void setTestProbe(IFileReaderProbe probe) {
        testProbe = probe;
    }

    private synchronized void setStatistics(ProgressStatistics statistics) {
        this.statistics = statistics;
    }

    private synchronized ProgressStatistics getStatistics() {
        return this.statistics;
    }

    protected class CancelHandler
    extends Job {
        private boolean done;

        protected CancelHandler() {
            super(Messages.FileReader_cancelHandler);
            this.done = false;
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor jobMonitor) {
            while (!this.done && !jobMonitor.isCanceled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                if (FileReader.this.theMonitor == null || !FileReader.this.theMonitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            Thread t = this.getThread();
            if (t != null) {
                t.interrupt();
            }
        }
    }

    private static class DownloadRange
    implements IFileRangeSpecification {
        private long startPosition;

        public DownloadRange(long startPos) {
            this.startPosition = startPos;
        }

        public long getEndPosition() {
            return -1L;
        }

        public long getStartPosition() {
            return this.startPosition;
        }
    }

    public static interface IFileReaderProbe {
        public void onStart(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);

        public void onData(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);

        public void onDone(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);
    }
}

